#ifndef WIN32

#ifndef MEETINGACCOUNTSDKWRAP_H
#define MEETINGACCOUNTSDKWRAP_H

#include "MeetingSiteImpl.h"
#include "sdkwrapper/mac/MeetingSDKWrap.h"
#include "wbx_meeting_account_def.h"
#include "JabberMeetingAccountSync.h"


using namespace JM_SDK;

namespace CSFUnified
{
    class MeetingAccountSDKWrap : public IWbxMeetingAccountValidationEvent
    {
    public:
        ~MeetingAccountSDKWrap();
        static MeetingAccountSDKWrap * getInstance();
        
        void start();
        void stop();
        
        void verifyAccountWithPassword(std::string siteUrl, std::string userName, csf::SecureString userPass);
        void verifyAccountWithSessionTicket(std::string siteUrl, std::string userName, std::string sessionTicket);
        void deleteDefaultAccount();
        void checkSSOSite(std::string siteUrl);
        void checkSSOSiteList(std::list<std::string> siteList);
        int isSSOSite(std::string siteUrl);
        
        
        
        virtual void onCheckSiteListSSOInfo();
        virtual void onCheckSiteSSOInfo(WBX_MEETING_ACCOUNT_ERROR errorCode, const PString url, CHECK_SITE_SSO_RESULT result);
        virtual void onVerifyAccount(WBX_MEETING_ACCOUNT_ERROR result, const WbxMeetingAccountProperty& accountProperty, const WbxMeetingSiteProperty& siteProperty);
        
    private:
        MeetingAccountSDKWrap();
        JABBER_MEETING_ACCOUNT_ERROR_CODE convertErrorCode(WBX_MEETING_ACCOUNT_ERROR errorCode);
        
    private:
        IWbxMeetingAccountValidation * m_pValidation;
        IWbxMeetingAccountOperator * m_pOperator;
    };
}

#endif

#endif